`include "WORKAROUND.svh"

import other_pkg::*;

module reg_temps ( input logic clk, input logic ares,
                   apb_if.slave apb,
                   output temp_t [DEC:JAN][HI:LO] temps );

    import apb_pkg::*;

    apb_resp_s resp;
    const int shift = 16;
    const apb_addr_e start_reg = REG_TEMP_JAN;

    always_comb begin
        resp = '{ default: 0 };
`ifdef WORKAROUND_foreach
        for ( int month = JAN; month <= DEC; month++ )
	    for ( int range = LO; range <= HI; range++ ) begin : rd_loop
`else
        foreach ( temps[month,range] ) begin : rd_loop
`endif
		apb_data_t rdata;
		rdata = apb_data_t'(temps[month][range]);
`ifdef WORKAROUND_next_i
		if ( apb.ReadReg( apb_addr_e'( REG_TEMP_JAN + month ) ) ) begin
`else
		if ( apb.ReadReg( start_reg.next(month) ) ) begin
`endif
                    resp.ready = 1;
                    resp.rdata = resp.rdata | ( rdata << (range*shift) );
		end
	    end
    end

    always_ff @( posedge clk or posedge ares ) begin
        if ( ares ) begin
            temps    <= 0;
            apb.resp <= '{ default: 0 };
        end
        else begin
`ifdef WORKAROUND_foreach
            for ( int month = JAN; month <= DEC; month++ )
		for ( int range = LO; range <= HI; range++ ) begin : wr_loop
`else
            foreach ( temps[month,range] ) begin : wr_loop
`endif
                    localparam int width = $bits(temp_t);
                    apb_data_t wdata;
                    wdata = apb.req.wdata[shift+:width];
`ifdef WORKAROUND_next_i
                    if ( apb.WriteReg( apb_addr_e'( REG_TEMP_JAN + month ) ) )
`else
                    if ( apb.WriteReg( start_reg.next(month) ) )
`endif
			temps[month][range] <= wdata;
		end
            if ( ~apb.req.write & apb.req.enable ) apb.resp <= resp;
        end
    end

endmodule
