`include "WORKAROUND.svh"

module array_or

`ifdef WORKAROUND_optional_parameter_keyword
    #( parameter int NUM = 1, parameter type OR_t = logic )
`else
    #( int NUM = 1, type OR_t = logic )
`endif

    (
     input  OR_t [NUM-1:0] in,
     output OR_t out
     );

    always_comb begin
	out = '{ default: 0 };
`ifdef WORKAROUND_foreach
	for ( int idx = 0; idx < NUM; idx++ ) out = out | in[idx];
`else
	foreach ( in[idx] ) out = out | in[idx];
`endif
    end

endmodule
