////////////////////////////////////////////////////////////////////////////////
//
// PROJECT NAME: vibration_sensor
//
// LIBRARY NAME: frontend
//
// MODULE NAME:  sensor_frontend
//
// DESCRIPTION OF MODULE:
//      
//
// DESCRIPTION OF PORTS: 
// inp of type double	
//      
// out of type sc_int<NBitsADC>	
//      
// k of type int	
//      
// 
// DESCRIPTION OF PARAMETER:
//
// this file was generated by 'sca_xml2netlist_cpp.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : SystemC AMS netlister
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////

//include submodules
#include "adc.h"
#include "pga.h"
#include "gain_controller.h"
#include "clk_gen.h"
#include "adc_reg.h"


#ifndef _VIBRATION_SENSOR_FRONTEND_SENSOR_FRONTEND_H_
//if this file is not included by the header keep implementation
#include "sensor_frontend.h"
#define FHG_INCLUDE_IMPLEMENTATION
#endif



namespace vibration_sensor_namespace
{

//component declarations
struct sensor_frontend::components
{

    //declare instance references for external access
    adc& i_adc1;
    pga& i_pga1;
    gain_controller& i_gain_controller1;
    clk_gen& i_clk_gen1;
    adc_reg& i_adc_reg1;

    //declare node and signal references for external access
    sca_tdf::sca_signal<double	 >& s_vamp;
    sc_core::sc_signal<bool	 >& s_clk;
    sc_core::sc_signal<sc_int<NBitsADC>	 >& s_adc_reg;

    //component constructor
    components(
                  adc *i_adc1_,
                  pga *i_pga1_,
                  gain_controller *i_gain_controller1_,
                  clk_gen *i_clk_gen1_,
                  adc_reg *i_adc_reg1_,
                  sca_tdf::sca_signal<double	 > &s_vamp_,
                  sc_core::sc_signal<bool	 > &s_clk_,
                  sc_core::sc_signal<sc_int<NBitsADC>	 > &s_adc_reg_
               ) :
                  i_adc1(*i_adc1_),
                  i_pga1(*i_pga1_),
                  i_gain_controller1(*i_gain_controller1_),
                  i_clk_gen1(*i_clk_gen1_),
                  i_adc_reg1(*i_adc_reg1_),
                  s_vamp(s_vamp_),
                  s_clk(s_clk_),
                  s_adc_reg(s_adc_reg_)
    {}

    //component destructor
    ~components()
    {
        //delete instances
        delete &i_adc1;
        delete &i_pga1;
        delete &i_gain_controller1;
        delete &i_clk_gen1;
        delete &i_adc_reg1;

        //delete signals
        delete &s_vamp;
        delete &s_clk;
        delete &s_adc_reg;
    }

};


#ifdef FHG_INCLUDE_IMPLEMENTATION


/////////////////////////////////////////////////////////////////////////////
//    architecture implementation (netlist)
/////////////////////////////////////////////////////////////////////////////

void sensor_frontend::architecture()
{
  //generate nodes/signals - map to references and name
  sca_tdf::sca_signal<double	 >& s_vamp(* new sca_tdf::sca_signal<double	 >("s_vamp"));
  sc_core::sc_signal<bool	 >& s_clk(* new sc_core::sc_signal<bool	 >("s_clk"));
  sc_core::sc_signal<sc_int<NBitsADC>	 >& s_adc_reg(* new sc_core::sc_signal<sc_int<NBitsADC>	 >("s_adc_reg"));

  ///////////////////////////////////////////////////////////////////////////
  // instantiate modules, assign parameter                                 //
  ///////////////////////////////////////////////////////////////////////////
    adc::params p_i_adc1;
    p_i_adc1.v_max = 5.0;
    adc *i_adc1;
    i_adc1 = new adc("i_adc1", p_i_adc1);
    //port binding see netlist section

    pga::params p_i_pga1;
    p_i_pga1.v_supply = 5.0;
    pga *i_pga1;
    i_pga1 = new pga("i_pga1", p_i_pga1);
    //port binding see netlist section

    gain_controller::params p_i_gain_controller1;
    p_i_gain_controller1.low_threshold = 0.2 * ((1 << (NBits - 1)) - 1);
    p_i_gain_controller1.high_threshold = 0.66 * ((1 << (NBits - 1)) - 1);
    p_i_gain_controller1.k_0 = 8;
    p_i_gain_controller1.k_min = 0;
    p_i_gain_controller1.k_max = 16;
    p_i_gain_controller1.n_samples_avr = 50;
    gain_controller *i_gain_controller1;
    i_gain_controller1 = new gain_controller("i_gain_controller1", p_i_gain_controller1);
    //port binding see netlist section

    clk_gen::params p_i_clk_gen1;
    p_i_clk_gen1.period = sc_time(10.0,SC_US);
    p_i_clk_gen1.init = false;
    p_i_clk_gen1.start = SC_ZERO_TIME;
    p_i_clk_gen1.jitter = 20.0;
    clk_gen *i_clk_gen1;
    i_clk_gen1 = new clk_gen("i_clk_gen1", p_i_clk_gen1);
    //port binding see netlist section

    adc_reg::params p_i_adc_reg1;
    adc_reg *i_adc_reg1;
    i_adc_reg1 = new adc_reg("i_adc_reg1", p_i_adc_reg1);
    //port binding see netlist section


  ///////////////////////////////////////////////////////////////////////////
  // netlist section                                                       //
  ///////////////////////////////////////////////////////////////////////////
    //i_adc1 (adc)
    i_adc1 -> in.bind(s_vamp);
    i_adc1 -> out.bind(out);
    i_adc1 -> clk.bind(s_clk);

    //i_pga1 (pga)
    i_pga1 -> in.bind(inp);
    i_pga1 -> out.bind(s_vamp);
    i_pga1 -> k_in.bind(k);

    //i_gain_controller1 (gain_controller)
    i_gain_controller1 -> clk.bind(s_clk);
    i_gain_controller1 -> amp_in.bind(s_adc_reg);
    i_gain_controller1 -> k_out.bind(k);

    //i_clk_gen1 (clk_gen)
    i_clk_gen1 -> clk.bind(s_clk);

    //i_adc_reg1 (adc_reg)
    i_adc_reg1 -> inp.bind(out);
    i_adc_reg1 -> outp.bind(s_adc_reg);




/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//    initialize struct for external(e.g. tb)  access                      //
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

  c = new components(
                       i_adc1,
                       i_pga1,
                       i_gain_controller1,
                       i_clk_gen1,
                       i_adc_reg1,
                       s_vamp,
                       s_clk,
                       s_adc_reg
                     );

}


 ////////////////////////////////////////////////////////////////////////////
 ////////////////////////////////////////////////////////////////////////////
 ////////////////////////////////////////////////////////////////////////////


//constructor implementation
sensor_frontend::sensor_frontend(sc_module_name name, params pa) :
          //naming ports for debugging
          inp("inp"),
          out("out"),
          k("k"),
          p(pa)
{

     architecture();
}

//destructor implementation
sensor_frontend::~sensor_frontend()
{

    //delete component structure
    delete c;
}



#endif //#ifdef FHG_INCLUDE_IMPLEMENTATION

}  //end namespace vibration_sensor_namespace

//remove temporary defines
#undef DONT_INCLUDE_HIERARCHIC_COMPONENTS
#undef FHG_INCLUDE_IMPLEMENTATION


