/*****************************************************************************

  The following code is derived, directly or indirectly, from the SystemC
  source code Copyright (c) 1996-2014 by all Contributors.
  All Rights reserved.

  The contents of this file are subject to the restrictions and limitations
  set forth in the SystemC Open Source License (the "License");
  You may not use this file except in compliance with such restrictions and
  limitations. You may obtain instructions on how to receive a copy of the
  License at http://www.accellera.org/. Software distributed by Contributors
  under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
  ANY KIND, either express or implied. See the License for the specific
  language governing rights and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  datatypes.cpp -- 

  Original Author: Rocco Jonack, Synopsys, Inc., 1999-07-14

 *****************************************************************************/

/*****************************************************************************

  MODIFICATION LOG - modifiers, enter your name, affiliation, date and
  changes you are making here.

      Name, Affiliation, Date:
  Description of Modification:

 *****************************************************************************/

#include "datatypes.h"
#define true 1
#define false  0

void datatypes::entry()

{

  sc_bigint<8>    tmp1;
  sc_bigint<8>    tmp1r;
  sc_biguint<8>   tmp2;
  sc_biguint<8>   tmp2r;
  long            tmp3;
  long            tmp3r;
  int             tmp4;
  int             tmp4r;
  short           tmp5;
  short           tmp5r;
  char            tmp6;
  char            tmp6r;

// define 1 dimensional array
   int  tmp7[2];
   char tmp8[2];
   // int  tmp9[2];
   int* tmp9;

// define sc_bool_vector
  sc_bv<4>	tmp10;
  tmp10[3] = 0;  tmp10[2] = 1;  tmp10[1] = 0;  tmp10[0] = 1;

// define 2 dimentional array
   sc_bv<1> tmp11[2];

// reset_loop
  if (reset.read() == true) {
    out_valid.write(false);
    out_ack.write(false);
    wait();
  } else wait();

//
// main loop
//

// initialization of sc_array

   tmp7[0] = 3;
   tmp7[1] = 12;
   tmp8[0] = 'S';
   tmp8[1] = 'C';
   tmp9 = tmp7;
   tmp11[0][0] = "1";
   tmp11[1][0] = "0";


 while(1) {
    while(in_valid.read()==false) wait();

    //reading the inputs
    tmp1 = in_value1.read();
    tmp2 = in_value2.read();
    tmp3 = in_value3.read();
    tmp4 = in_value4.read();
    tmp5 = in_value5.read();
    tmp6 = in_value6.read();
    
    out_ack.write(true);

    //execute mixed data type addition operations
    tmp1r = tmp1 + tmp2 + (sc_bigint<1>)tmp1.range(0, 0) ; // ####
    // tmp2r = tmp6 + tmp1 + int(tmp10[2]);	// treat tmp10[2] as carry in
    tmp2r = tmp6 + tmp1 + tmp10[2].to_bool();	// treat tmp10[2] as carry in
    tmp3r = tmp4 + tmp6;
    tmp4r = ++tmp5;
    // tmp4r -= int(tmp11[0][0]);
    tmp4r -= tmp11[0][0].to_bool();
    tmp5r = tmp6 + tmp4;
    tmp6r = tmp8[0] + tmp9[1];

    //write outputs
    out_value1.write(tmp1r);
    out_value2.write(tmp2r);
    out_value3.write(tmp3r);
    out_value4.write(tmp4r);
    out_value5.write(tmp5r);
    out_value6.write(tmp6r);
  
    out_valid.write(true);
    wait();
    out_ack.write(false);
    out_valid.write(false);

 }

} // End 

