/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test sca_tdf::sca_de::sca_in<sc_dt::sc_logic> member functions
// set_delay() and get_delay() with delay set to 2

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE( mod_a )
{
  sc_core::sc_out<sc_dt::sc_logic> out;

  void gen()
  {
    while (true)
    {
      switch (cnt)
      {
        case 0: out.write(sc_dt::SC_LOGIC_Z); cnt++; break;
        case 1: out.write(sc_dt::SC_LOGIC_X); cnt++; break;
        case 2: out.write(sc_dt::SC_LOGIC_1); cnt++; break;
        case 3: out.write(sc_dt::SC_LOGIC_0); cnt = 0; break;
        default: cnt = 0;
      }
      wait(sc_core::sc_time(1, sc_core::SC_MS));
    }
  }

  SC_CTOR( mod_a ) : out("out"), cnt(0)
  {
    SC_THREAD( gen );
  }

  int cnt;
};


SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_de::sca_in<sc_dt::sc_logic> in;
  sca_tdf::sca_out<sc_dt::sc_logic> out;

  void set_attributes()
  {
    in.set_delay(in_delay);
  }

  void initialize()
  {
    for (int i = 0; i < in_delay; i++)
    {
      in.initialize(sc_dt::SC_LOGIC_X, i);
    }
    std::cout << "in.set_delay() set to: " << in_delay << std::endl;
    std::cout << "in.get_delay(): " << in.get_delay() << std::endl;
  }

  void processing()
  {
    val = in.read();
    out.write(val);
  }

  SCA_CTOR( mod_b ) : in("in"), out("out"), in_delay(2) {}

private:
  int in_delay;
  sc_dt::sc_logic val;

};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<sc_dt::sc_logic> tdf_sig;
  sc_core::sc_signal<sc_dt::sc_logic> sc_sig1;

  mod_a a("a");
    a.out(sc_sig1);

  mod_b b("b");
    b.in(sc_sig1);
    b.out(tdf_sig);
    b.set_timestep(1.0, sc_core::SC_MS);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test05");

  sca_util::sca_trace(atf, sc_sig1, "sc_sig1");
  sca_util::sca_trace(atf, tdf_sig, "tdf_sig");
  
  sc_core::sc_start(10.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test05", 2);
  
  TEST_LABEL_END;

  return 0;
}
