/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test if sca_tdf::sca_de::sca_in<bool> is derived from
//   sca_core::sca_port< sc_core::sc_signal_in_if >

#include <systemc-ams>
#include "test_utilities.h"

template <class T>
class my_port : public sca_tdf::sca_de::sca_in<T>
{};

template <class T>
class my_port_td : public sca_tdf::sc_in<T>
{};

SCA_TDF_MODULE( mod_a )
{
  typedef sca_core::sca_port< sc_core::sc_signal_in_if<bool> > port_base;

  SCA_CTOR( mod_a )
  {
    my_port1 = new my_port<bool>();
    my_port2 = new my_port_td<bool>();

    std::cout << "my_port1.kind(): " << my_port1->kind() << std::endl;
    std::cout << "my_port2.kind(): " << my_port2->kind() << std::endl;

    port_base* obj1 = dynamic_cast<port_base*>(my_port1);
    port_base* obj2 = dynamic_cast<port_base*>(my_port2);
  }

  ~mod_a()
  {
    delete my_port1, my_port2;
  }

 private:
  my_port<bool>* my_port1;
  my_port_td<bool>* my_port2;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  mod_a a("a");

  TEST_LABEL_END;

  return 0;
}
