/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test constructor/operator of sca_lsf::sca_in with and without argument

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE( mod_a )
{
  sca_lsf::sca_out out1;
  sca_lsf::sca_out out2;
  
  SC_CTOR( mod_a ) : out1(), out2("out2") {}
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;
  
  mod_a a("a");
  
  std::cout << "a.out1.kind() : " << a.out1.kind() << std::endl;

  std::cout << "a.out2.kind() : " << a.out2.kind() << std::endl;
  std::cout << "a.out2.name() : " << a.out2.name() << std::endl;
  
  TEST_LABEL_END;
    
  return 0;
}
