/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#include <systemc-ams>

#ifndef ZDIODE_DTDF_H_
#define ZDIODE_DTDF_H_

class dtdf_rectifier;
class zdiode_dtdf;

namespace sca_util
{
  void sca_trace(sca_util::sca_trace_file* tf, const zdiode_dtdf& rect, const std::string& nm);
}

class dtdf_rectifier_ctrl;

SC_MODULE(zdiode_dtdf)
{
  sca_eln::sca_terminal p;
  sca_eln::sca_terminal n;

  struct params
  {
    double vth_p;
    double vth_n;
    double ron;
    double roff;

    params()
    {
      vth_p = 0.7;
      vth_n = -53.0;
      ron = 1e-3;
      roff = 1e8;
    }

  } _p;

  zdiode_dtdf(sc_core::sc_module_name, const params& _p = params());

  ~zdiode_dtdf(); // destructor

private:
  friend void sca_util::sca_trace(sca_util::sca_trace_file* tf, const zdiode_dtdf& rect, const std::string& nm);

  sca_eln::sca_tdf_vsource* vth;
  sca_eln::sca_tdf::sca_r* rrect;
  sca_eln::sca_tdf_vsink* vrect;

  dtdf_rectifier_ctrl* rctrl;

  sca_tdf::sca_signal<double> s_vin;
  sca_tdf::sca_signal<double> s_rout;
  sca_tdf::sca_signal<double> s_vth;

  sca_eln::sca_node n1;
};

#endif /* ZDIODE_DTDF_H_ */
