/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test if sca_core::sca_prim_channel is derived from sc_core::sc_object

#include <systemc-ams>
#include "test_utilities.h"

struct channel : public sca_core::sca_prim_channel
{
  channel() {}
  ~channel() {}
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  channel* channel1 = new channel();
  sc_core::sc_object* obj = dynamic_cast<sc_core::sc_object*>(channel1);

  std::cout << "kind channel: ";
  std::cout << channel1->kind() << std::endl;

  TEST_LABEL_END;

  delete channel1;
  
  return 0;
}
