/**
 *
 * @file resource_user.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: event.cc 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#include "resource_user.hh"

#include <boost/lexical_cast.hpp>

#include <systemc>


namespace sctg
{
   ResourceUser::ResourceUser(const boost::property_tree::ptree& pt,
			      Configuration& config)
      :
      _config(config)
   {
      using boost::property_tree::ptree;

      // Read in task's name and other attributes
      _id = pt.get<unsigned long int>("<xmlattr>.id");
      // Default name is "Task <id>"
      _name = pt.get<std::string>
	 ("<xmlattr>.name", "Task " + boost::lexical_cast<std::string>(_id));
      // Class must be present
      _class = pt.get<std::string>("<xmlattr>.class");


      // Read in all in_ports and out_ports
      for(ptree::const_iterator iter = pt.begin(); iter != pt.end(); ++iter)
      {
	 if((*iter).first == "in_port")
	 {
	    unsigned long int in_port = 
	       (*iter).second.get<unsigned long int>("<xmlattr>.id");
	    _inPorts.push_back(in_port);
	    config.addResourceUserToInPortMap(in_port, this);	    
// 	    std::cout << "ResourceUser " << getName() << " has in_port " 
// 		      << in_port << std::endl;
	 }
	 else if((*iter).first == "out_port")
	 {
	    unsigned long int out_port =
	       (*iter).second.get<unsigned long int>("<xmlattr>.id");
	    _outPorts.push_back(out_port);
// 	    std::cout << "ResourceUser " << getName() << " has out_port " 
// 		      << out_port << std::endl;
	 }
      }
   }

   ResourceUser::~ResourceUser()
   {
   }

   const std::string& ResourceUser::getName()
   { return _name; }

   const std::string& ResourceUser::getClass()
   { return _class; }

   unsigned long int ResourceUser::getId()
   { return _id; }

   std::vector<unsigned long int>& ResourceUser::getOutPorts()
   { return _outPorts; }

   std::vector<unsigned long int>& ResourceUser::getInPorts()
   { return _inPorts;  }
}


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
