/**
 *
 * @file ring_factory_vhd.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: ring_factory_vhd.hh 1956 2011-08-22 14:41:32Z lehton87 $
 *
 */

#ifndef SCTG_VHD_RING_FACTORY_HH
#define SCTG_VHD_RING_FACTORY_HH


#include "vhd/ring_with_pkt_codec_vhd_bfm.hh"
#include "noc_conf_if.hh"

#include <systemc>

namespace sctg
{
   namespace ring_vhd
   {

      class RingFactoryVHD
      {
      public:
   
	 RingFactoryVHD(sctg::NocConfIf* nocConfIf);
   
	 virtual ~RingFactoryVHD();      
   
      private:

	 ring_with_pkt_codec_vhd_bfm<3, 32, 8>*  ringi3;
	 ring_with_pkt_codec_vhd_bfm<4, 32, 8>*  ringi4;
	 ring_with_pkt_codec_vhd_bfm<5, 32, 8>*  ringi5;
	 ring_with_pkt_codec_vhd_bfm<6, 32, 8>*  ringi6;
	 ring_with_pkt_codec_vhd_bfm<7, 32, 8>*  ringi7;
	 ring_with_pkt_codec_vhd_bfm<8, 32, 8>*  ringi8;
	 ring_with_pkt_codec_vhd_bfm<16, 32, 8>* ringi16;
	 ring_with_pkt_codec_vhd_bfm<32, 32, 8>* ringi32;
	 ring_with_pkt_codec_vhd_bfm<64, 32, 8>* ringi64;
      };

   }
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
