/**
 *
 * @file ocp_tl3_mesh_2d.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: ocp_tl3_mesh_2d.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#ifndef SCTG_OCPTL3_MESH_2_D_HH
#define SCTG_OCPTL3_MESH_2_D_HH

#include "sc_ocp_tl3_1/ocp_tl3_mesh_router.hh"


#ifdef MTI_SYSTEMC

#else

#endif

#include <systemc>
#include <iostream>

namespace sctg
{
   namespace mesh_2d_sc_ocp_tl3_1
   {

      template<unsigned int data_width_g,
	       unsigned int rows_g,
	       unsigned int cols_g,
	       unsigned int cycle_length_ns_g>
      class OcpTl3Mesh2D : public sc_core::sc_module
      {
      public:

	 SC_HAS_PROCESS(OcpTl3Mesh2D);	 

	 ocpip::ocp_master_socket_tl3<data_width_g, 1>*
	 masterSocket[rows_g*cols_g];
	 ocpip::ocp_slave_socket_tl3<data_width_g, 1>*
	 slaveSocket[rows_g*cols_g];

	 
	 //* Constructor
	 OcpTl3Mesh2D(sc_core::sc_module_name name)
	    : sc_core::sc_module(name)
	 {
	    // OCP-IP parameters
	    _ocpParameters.byteen = false;

	    // Create routers
	    for(unsigned int x = 0; x < cols_g; ++x)
	    {
	       for(unsigned int y = 0; y < rows_g; ++y)
	       {
		  std::ostringstream oss;
		  oss << "router_" << y << "_" << x;
		  _routers[y*cols_g+x] = new OcpTl3MeshRouter<data_width_g>
		     (oss.str().c_str(), y, x, rows_g, cols_g, 
		      sc_core::sc_time(cycle_length_ns_g, sc_core::SC_NS));
		     
	       }
	    }
	    
	    
	    // Bind sockets hierarchically
	    for(unsigned int y = 0; y < rows_g; ++y)
	    {
	       for(unsigned int x = 0; x < cols_g; ++x)
	       {
		  std::ostringstream oss;
		  oss << "masterSocket_" << y << "_" << x;
		  //std::cout << oss.str() << std::endl;
		  masterSocket[y*cols_g+x] = new ocpip::ocp_master_socket_tl3
		     <data_width_g, 1>
		     (oss.str().c_str(), 
		      ocpip::ocp_master_socket_tl3<data_width_g, 1>::mm_txn_with_data());

		  (*_routers[y*cols_g+x]).masterSocket[4]->bind(*masterSocket[y*cols_g+x]);
		  masterSocket[y*cols_g+x]->set_ocp_config(_ocpParameters);

		  oss.str("");
		  //oss << "slaveSocket_" << y << "_" << x;
		  std::cout << oss.str() << std::endl;
		  slaveSocket[y*cols_g+x] = new ocpip::ocp_slave_socket_tl3
		     <data_width_g, 1>
		     (oss.str().c_str());
		  slaveSocket[y*cols_g+x]->bind(*((*_routers[y*cols_g+x]).slaveSocket[4]));
		  slaveSocket[y*cols_g+x]->set_ocp_config(_ocpParameters);

		  if(x > 0)
		  {
		     unsigned int t = y * cols_g + x - 1;
		     unsigned int i = y * cols_g + x;
		     (*_routers[i]->masterSocket[1]).
			bind(*_routers[t]->slaveSocket[3]);
		     (*_routers[t]->masterSocket[3]).
			bind(*_routers[i]->slaveSocket[1]);
		  }
		  if(y > 0)
		  {
		     unsigned int t = (y-1) * cols_g + x;
		     unsigned int i = y * cols_g + x;
		     (*_routers[i]->masterSocket[0]).
			bind(*_routers[t]->slaveSocket[2]);
		     (*_routers[t]->masterSocket[2]).
			bind(*_routers[i]->slaveSocket[0]);
		  }
	       }
	    }

	 }

	 ~OcpTl3Mesh2D()
	 {
	    std::cout << "OcpTl3Mesh2D destructor" << std::endl;
	    for(unsigned int x = 0; x < cols_g; ++x)
	    {
	       for(unsigned int y = 0; y < rows_g; ++y)
	       {
		  delete _routers[y*cols_g+x];
		  delete masterSocket[y*cols_g+x];
		  delete slaveSocket[y*cols_g+x];
	       }
	    }
	 }

      private:

	 OcpTl3MeshRouter<data_width_g>* _routers[rows_g*cols_g];

	 ocpip::ocp_parameters _ocpParameters;

      };

   }
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

