/**
 *
 * @file noc_factory.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: noc_factory.cc 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#include "noc_factory.hh"

#include <systemc>

#include <iostream>
#include <stdexcept>
#include <string>

NocFactory::NocFactory(sctg::NocConfIf* nocConfIf)
   : _mesh_factory(0),
     _sbus_factory(0)
{
   std::string nocClass = nocConfIf->getNocClass();

   if(nocClass == "mesh_2d")
   {
      _mesh_factory = new asebt::MeshFactory(nocConfIf);
   }
   else if(nocClass == "simple_bus")
   {
      _sbus_factory = new asebt::SBusFactory(nocConfIf);
   }
   else
   {
      std::ostringstream oss;
      oss << "NocFactory: NoC with class \"" << nocClass 
	  << " not found";
      throw std::runtime_error(oss.str().c_str());
   }
}

NocFactory::~NocFactory()
{
   if(_mesh_factory)  { delete _mesh_factory;  _mesh_factory  = 0; }
   if(_sbus_factory)  { delete _sbus_factory;  _sbus_factory  = 0; }
}





// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

