/**
 * File:    ModelEvent.java
 * Author:  Tomi Jantti <tomi.jantti@tut.fi>
 * Created: 29.3.2007
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.event;

import java.util.EventObject;

import fi.cpu.data.ModelNode;


/**
 * ModelEvent contains information about a change
 * in the Model.
 */
public class ModelEvent extends EventObject {
	private ModelNode node;
	private ModelNode currentParent;
	private ModelNode oldParent;
	
	/**
	 * Creates a new ModelEvent.
	 * @param source        Instance of Model.
	 * @param node          Node that changed.
	 * @param currentParent Current parent of the node, or null if none.
	 * @param oldParent     Previous parent of the node, or null if none.
	 */
	public ModelEvent(Object source, ModelNode node,
			ModelNode currentParent, ModelNode oldParent) {
		super(source);
		this.node = node;
		this.currentParent = currentParent;
		this.oldParent = oldParent;
	}

	
	/**
	 * @return Returns the node.
	 */
	public ModelNode getNode() {
		return node;
	}

	
	/**
	 * @return Returns the currentParent.
	 */
	public ModelNode getCurrentParent() {
		return currentParent;
	}

	
	/**
	 * @return Returns the oldParent.
	 */
	public ModelNode getOldParent() {
		return oldParent;
	}
}
