///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2004 OCP-IP
// OCP-IP Confidential & Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc.
//          Date: 01/06/2005
//
//  Description :  OCP Channel Transaction Recording Monitor
//	  This channel monitor is based on the transaction recording
//	  API in the SystemC Verification (SCV) Library. It targets
//	  performance analysis for architectural modeling.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OCP_PERF_MONITOR_EXTENSIONS_H__
#define __OCP_PERF_MONITOR_EXTENSIONS_H__

// MCmd encoding
template<>
class scv_extensions<ocpip_legacy::OCPMCmdType> : public scv_enum_base<ocpip_legacy::OCPMCmdType> {
public:

  SCV_ENUM_CTOR(ocpip_legacy::OCPMCmdType) {
    SCV_ENUM(ocpip_legacy::OCP_MCMD_IDLE);
    SCV_ENUM(ocpip_legacy::OCP_MCMD_WR);
    SCV_ENUM(ocpip_legacy::OCP_MCMD_RD);
    SCV_ENUM(ocpip_legacy::OCP_MCMD_RDEX);
    SCV_ENUM(ocpip_legacy::OCP_MCMD_RDL);
    SCV_ENUM(ocpip_legacy::OCP_MCMD_WRNP);
    SCV_ENUM(ocpip_legacy::OCP_MCMD_WRC);
    SCV_ENUM(ocpip_legacy::OCP_MCMD_BCST);
  }
};

// SResp encoding
template<>
class scv_extensions<ocpip_legacy::OCPSRespType> : public scv_enum_base<ocpip_legacy::OCPSRespType> {
public:

  SCV_ENUM_CTOR(ocpip_legacy::OCPSRespType) {
    SCV_ENUM(ocpip_legacy::OCP_SRESP_NULL);
    SCV_ENUM(ocpip_legacy::OCP_SRESP_DVA);
    SCV_ENUM(ocpip_legacy::OCP_SRESP_FAIL);
    SCV_ENUM(ocpip_legacy::OCP_SRESP_ERR);
  }
};

// MBurstSeq encoding
template<>
class scv_extensions<ocpip_legacy::OCPMBurstSeqType> : public scv_enum_base<ocpip_legacy::OCPMBurstSeqType> {
public:

  SCV_ENUM_CTOR(ocpip_legacy::OCPMBurstSeqType) {
    SCV_ENUM(ocpip_legacy::OCP_MBURSTSEQ_INCR);
    SCV_ENUM(ocpip_legacy::OCP_MBURSTSEQ_DFLT1);
    SCV_ENUM(ocpip_legacy::OCP_MBURSTSEQ_WRAP);
    SCV_ENUM(ocpip_legacy::OCP_MBURSTSEQ_DFLT2);
    SCV_ENUM(ocpip_legacy::OCP_MBURSTSEQ_XOR);
    SCV_ENUM(ocpip_legacy::OCP_MBURSTSEQ_STRM);
    SCV_ENUM(ocpip_legacy::OCP_MBURSTSEQ_UNKN);
    SCV_ENUM(ocpip_legacy::OCP_MBURSTSEQ_BLCK);
    SCV_ENUM(ocpip_legacy::OCP_MBURSTSEQ_RESERVED);
  }
};


////////////////////////////////////////////////////
// TL2 RequestGrp holds the OCP request information
////////////////////////////////////////////////////
template<class Td, class Ta>
class scv_extensions<ocpip_legacy::OCPTL2RequestGrp<Td,Ta> > : public scv_extensions_base<ocpip_legacy::OCPTL2RequestGrp<Td,Ta> > {
public:
  // OCP Basics
  scv_extensions<ocpip_legacy::OCPMCmdType> MCmd;
  scv_extensions<Ta> MAddr;
  scv_extensions<Td*> MDataPtr;
  scv_extensions<unsigned int> DataLength;

  // OCP Basics +
  scv_extensions<unsigned int> MAddrSpace;
  scv_extensions<unsigned int> MByteEn;
  scv_extensions<unsigned int*> MByteEnPtr;
  scv_extensions<uint64> MReqInfo;
  scv_extensions<unsigned int> MTagID;
  scv_extensions<unsigned int> MTagInOrder;
  scv_extensions<uint64> MDataInfo;
  scv_extensions<uint64*> MDataInfoPtr;

  // OCP Threads
  scv_extensions<unsigned int> MThreadID;
  scv_extensions< unsigned int> MConnID;

  // OCP Burst Information
  scv_extensions< unsigned int> MBurstLength;
  scv_extensions<unsigned int>  MBlockHeight;
  scv_extensions<unsigned int>  MBlockStride;
  scv_extensions<bool> MBurstPrecise;
  scv_extensions<ocpip_legacy::OCPMBurstSeqType> MBurstSeq;
  scv_extensions<bool> MBurstSingleReq;

  // Partial Burst Help
  scv_extensions<bool> LastOfBurst;
  scv_extensions<unsigned int>  LastOfRow;

  // system level transaction recording
  scv_extensions<long long> TrHandle;


  typedef ocpip_legacy::OCPTL2RequestGrp<Td,Ta> OCPTL2RequestGrp;
  using scv_extensions_base<OCPTL2RequestGrp>::_set_instance;
  using scv_extensions_base<OCPTL2RequestGrp>::_get_instance;
  SCV_EXTENSIONS_CTOR(OCPTL2RequestGrp) {
    // below must be in order!
    // OCP Basics
    SCV_FIELD(MCmd);
    SCV_FIELD(MAddr);
    SCV_FIELD(MDataPtr);
    SCV_FIELD( DataLength);

    // OCP Basics +
    SCV_FIELD( MAddrSpace);
    SCV_FIELD(MByteEn);
    SCV_FIELD(MByteEnPtr);
    SCV_FIELD(MReqInfo);
    SCV_FIELD(MTagID);
    SCV_FIELD(MTagInOrder);
    SCV_FIELD(MDataInfo);
    SCV_FIELD(MDataInfoPtr);
    // OCP Threads
    SCV_FIELD(MThreadID);
    SCV_FIELD(MConnID);

    // OCP Burst Information
    SCV_FIELD(MBurstLength);
    SCV_FIELD( MBlockHeight );
    SCV_FIELD( MBlockStride );
    SCV_FIELD(MBurstPrecise);
    SCV_FIELD(MBurstSeq);
    SCV_FIELD(MBurstSingleReq);

    // Partial Burst Help
    SCV_FIELD(LastOfBurst);
    SCV_FIELD(LastOfRow);

    // system level transaction recording
    SCV_FIELD(TrHandle);
  }
};

template<class Td>
class scv_extensions<ocpip_legacy::OCPTL2ResponseGrp<Td> > : public scv_extensions_base<ocpip_legacy::OCPTL2ResponseGrp<Td> > {
public:
  // OCP Basics
  scv_extensions<ocpip_legacy::OCPSRespType> SResp;
  scv_extensions<Td*> SDataPtr;
  scv_extensions<unsigned int> DataLength;

  // OCP Basics +
  scv_extensions< sc_dt::uint64> SDataInfo;
  scv_extensions<unsigned int> STagID;
  scv_extensions<bool> STagInOrder;
  scv_extensions<uint64> SRespInfo;

  // OCP Threads
  scv_extensions<unsigned int> SThreadID;

  // Partial Burst Support
  scv_extensions<bool> LastOfBurst;

  // system level transaction recording
  scv_extensions<long long> TrHandle;

  typedef ocpip_legacy::OCPTL2ResponseGrp<Td> OCPTL2ResponseGrp;
  using scv_extensions_base<OCPTL2ResponseGrp>::_set_instance;
  using scv_extensions_base<OCPTL2ResponseGrp>::_get_instance;
  SCV_EXTENSIONS_CTOR(OCPTL2ResponseGrp) {
    //must be in order

    // OCP Basics
    SCV_FIELD(SResp);
    SCV_FIELD(SDataPtr);
    SCV_FIELD(DataLength);

    // OCP Basics +
    SCV_FIELD(SDataInfo);
    SCV_FIELD(STagID);
    SCV_FIELD(STagInOrder);
    SCV_FIELD(SRespInfo);

    // OCP Threads
    SCV_FIELD(SThreadID);

    // Partial Burst Support
    SCV_FIELD(LastOfBurst);

    // system level transaction recording
    SCV_FIELD(TrHandle);
  }
};


#endif
