///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2009-2010
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Herve Alexanian - Sonics, inc.
//
//          $Id:
//
//  Description :  This file defines a layer adapter module for the TL1 slave
//                 socket. Designed to handler incoming TL1 traffic with certain
//                 user controls and a plug-in for OCP slave behavior.
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef OCPIP_VERSION
  #error ocp_tl1_tl3_master_adapter.h may not be included directly. Use #include "ocpip.h" or #include "ocpip_X_X_X.h" (where desired ocp version is X.X.X)
#endif

namespace OCPIP_VERSION {
template <unsigned int BUSWIDTH>
class ocp_tl1_tl3_master_adapter : public sc_core::sc_module
{
private:
    // define before socket
    ocp_tl1_slave_timing_guard                m_timing_guard;
public:
    sc_core::sc_in_clk                        clk;
    ocp_slave_socket_tl1<BUSWIDTH>            tl1_socket;
    ocp_master_socket<BUSWIDTH>               master_socket;

    struct config {
	uint32_t              max_active_req;
	uint32_t              max_active_resp_data;
	uint32_t              max_active_write_data;
	config() : max_active_req       ( static_cast<uint32_t>(-1) )
		 , max_active_resp_data ( static_cast<uint32_t>(-1) )
		 , max_active_write_data( static_cast<uint32_t>(-1) ) {}
    };
    config config;

    SC_HAS_PROCESS(ocp_tl1_tl3_master_adapter);
    ocp_tl1_tl3_master_adapter(sc_core::sc_module_name name_);
    ~ocp_tl1_tl3_master_adapter();

    void reset();

    // phase delay policy
    template <typename delay_calc_t>
    void set_delay_obj( tlm::tlm_phase ph, delay_calc_t obj ) {
	if ( ph == tlm::BEGIN_RESP )
	    m_p_resp_delay_calc = new delay_calc_t( obj );
	else if ( ph == tlm::END_REQ )
	    m_p_req_acc_delay_calc = new delay_calc_t( obj );
	else if ( ph == OCPIP_VERSION::END_DATA )
	    m_p_data_acc_delay_calc = new delay_calc_t( obj );
	else {
	    assert( false && "Delay phase must be BEGIN_RESP, END_REQ or END_DATA" );
	}
    }
private:
    typedef size_t thread_type;
    typedef size_t tag_type;
    typedef simple_phase_queue<ocp_tl1_phase_pos>          phase_queue;

    virtual void before_end_of_elaboration();
    ocp_parameters ocp_params;

    // transaction bookkeeping
    tlm_utils::instance_specific_extension_accessor        acc;
    ocp_extension_pool<ocp_txn_burst_invariant>            m_invariant_ext_pool;
    ocp_extension_pool<ocp_txn_position>                   m_position_ext_pool;
    std::vector<std::vector<ocp_txn_track> >               m_burst_tracker;

    // request/dh acceptance
    typedef phase_delayed_accept<ocp_tl1_tl3_master_adapter, uint32_t, ocp_tl1_phase_pos>  delayed_accept;
    delayed_accept    m_req_accept;
    delayed_accept    m_data_accept;
    ocp_tl1_phase_pos m_req_pending_acc;
    ocp_tl1_phase_pos m_data_pending_acc;
    void accept_req ( ocp_tl1_phase_pos& );
    void accept_data( ocp_tl1_phase_pos& );

    // flow control
    std::vector<uint32_t> m_num_active_req;
    std::vector<uint32_t> m_num_active_resp_data;
    std::vector<uint32_t> m_num_active_write_data;
    bool can_accept_req ( const ocp_tl1_phase_pos& ) const;
    bool can_accept_data( const ocp_tl1_phase_pos& ) const;
    sc_core::sc_event m_req_flow_control_ev;
    sc_core::sc_event m_data_flow_control_ev;
    void exert_req_flow_control();
    void exert_data_flow_control();

    // processing
    std::vector<std::vector<phase_queue*> >                m_req_txn;
    std::vector<phase_queue*>                              m_data_txn;
    simple_arb<thread_type, simple_rr_arb_algo>            m_thread_process_arb;
    std::vector<simple_arb<tag_type, simple_rr_arb_algo> > m_tag_process_arb;
    sc_core::sc_event                                      m_new_process_input_ev;
    void process_arb_th();
    void dispatch_phase( ocp_tl1_phase_pos& );
    void process_phase ( ocp_tl1_phase_pos& );

    // response arbitration
    std::vector<std::vector<phase_queue*> >                m_resp_txn;
    simple_arb<thread_type, simple_rr_arb_algo>            m_thread_resp_arb;
    arbiter_threadbusy_filter<thread_type>                 m_mthreadbusy_filt;
    std::vector<simple_arb<tag_type, simple_rr_arb_algo> > m_tag_resp_arb;
    sc_core::sc_event                                      m_new_resp_input_ev;
    void resp_arb_th();
    void send_response( thread_type, tag_type );
    void wait_mthreadbusy_stable();

    // phase delays
    void phase_delay_peq_out(); // SC_METHOD to exploit the mature PEQ items
    phase_delay_calc_if<uint32_t>*                   m_p_resp_delay_calc;
    phase_delay_calc_if<uint32_t>*                   m_p_req_acc_delay_calc;
    phase_delay_calc_if<uint32_t>*                   m_p_data_acc_delay_calc;
    ocp_cycle_based_peq<int>                         m_phase_delay_peq; // shared among threads/tags

    // TL1 timing propagation
    void update_timing();
    void set_tl1_master_timing( ocp_tl1_master_timing );
    sc_core::sc_time                                 m_send_resp_time;
    ocp_tl1_slave_timing                             m_my_tl1_timing;

    // threadbusy
    uint32_t m_cur_sthreadbusy    , m_next_sthreadbusy;
    uint32_t m_cur_sdatathreadbusy, m_next_sdatathreadbusy;
    uint32_t m_cur_mthreadbusy    , m_pipelined_mthreadbusy;
    void pipeline_threadbusy_signals();
    tlm::tlm_generic_payload* m_tb_txn;
    cmd_thread_busy*              m_tb;
    data_thread_busy*             m_dtb;

    // tl3 socket
    ocp_peq<ocp_master_socket<BUSWIDTH>, false>      m_tl3_peq;
    std::vector<std::vector<ocp_tl1_phase_pos> >     m_tl3_txn;
    tlm::tlm_sync_enum nb_transport_tl3(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);
    void               nb_process_tl3  (tlm::tlm_generic_payload& txn, const tlm::tlm_phase& ph);

    // tl1 socket
    tlm::tlm_sync_enum nb_transport_tl1(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);
    tlm::tlm_phase phase;
    sc_core::sc_time time;
    tlm::tlm_generic_payload* m_resp_issued;
    sc_core::sc_event m_resp_accept_ev;
    void handle_end_resp (tlm::tlm_generic_payload&);
    void release         (tlm::tlm_generic_payload&);

    static const uint32_t s_byte_width = (BUSWIDTH+7 >> 3);
    static const uint32_t s_interleave_size = 4;
};
}

#include __MACRO_STRINGYFY__(../src/OCPIP_VERSION/ocp_tl1_tl3_master_adapter.tpp)
