// 
//  Copyright 2003 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//      Authors : Yann Bajot, PROSILOG
//                Alan Kamas, Sonics Inc.
//         Date : 10/16/2003
//
//  Description:  TL2 Master used in the regression test 3 (see '.cpp' file for
//                more details)
//                
// ============================================================================


#ifndef _ocp20MasterSysC_h
#define _ocp20MasterSysC_h

#include <iostream>
#include <deque>
#include "stdlib.h"

// OCP-IP Channel header files
#include "ocp_globals.h"
#include "ocp_tl2_master_port.h"
#include "ocp_tl_param_cl.h"

// define the Master transactor class
class MasterSysC : public sc_module
{
  public:
    // --------------------------
    // public members and methods
    // --------------------------

    // type definitions
    typedef unsigned int Td;
    typedef unsigned int Ta;

    // member definitions

    // channel port
    OCP_TL2_MasterPort<Td,Ta> ipP;

    // SystemC macros
    // has SystemC processes
    SC_HAS_PROCESS(MasterSysC);

    // constructor and destructor
    MasterSysC(sc_module_name, ostream* debug_os_ptr = NULL);
    ~MasterSysC();

    void regtest(OCPResponseGrp<Td> resp, unsigned int chunk_length);

    // methods
    void setConfiguration( MapStringType& passedMap );

    // process methods
    void requestThreadProcess();
    void responseThreadProcess();

  protected:
    // ---------------------------
    // private members and methods
    // ---------------------------

    // SystemC methods
    void end_of_elaboration();

    // member definitions

    // offset used to send data; incremented after a complete request cycle has
    // been completed
    unsigned int m_data_offset_cycle;

    // Debug log file
    ostream* m_debug_os_ptr;

    // Parameters from the OCP Channel:

    // Class that holds all OCP parameters
    ParamCl<OCP_TL2_DataCl<Td,Ta> >* m_OCPParamP;

    // The number of threads
    int m_threads;
    
    // is MAddrSpace part of the OCP channel?
    bool m_addrspace;

    // is SThreadBusy part of the channel?
    bool m_sthreadbusy;

    // Is SThreadBusy compliance required?
    bool m_must_use_sthreadbusy;

    // is SDataThreadBusy part of the channel?
    bool m_sdatathreadbusy;

    // Is SDataThreadBusy compliance required?
    bool m_sdatathreadbusy_exact;

    // is MThreadBusy part of the channel?
    bool m_mthreadbusy;

    // Is MThreadBusy compliance required?
    bool m_must_use_mthreadbusy;

    // is MRespAccept part of the channel?
    bool m_respaccept;

    // is Data Handshake part of the channel?
    bool m_datahandshake;

    // is write response part of the channel?
    bool m_writeresp_enable;

    // is the READ-EX command part of the channel
    bool m_readex_enable;

    // Are non-posted writes (write commands that receive responses) part of the channel?
    bool m_writenonpost_enable; 

    // Given the width of the MBurstLength field, the longest possible burst
    int m_max_burst_len;

    // is MBurstSeq part of the OCP channel?
    bool m_burstseq;

    // is MBurstSingleReq part of the OCP channel?
    bool m_burstsinglereq;

    // amount to increment the address by for each INCR transfer in a burst
    int m_address_incr;

    //-----------------------------------------
    //  Master Specific Parameters
    //-----------------------------------------

    // Response delay style - fixed or random
    bool m_respaccept_fixeddelay;

    // Delay in accepting responses (max delay for random)
    int m_respaccept_delay;

    // Number of times to repeat the built-in set of requests.
    // (a value of 0, the default, is to repeat forever)
    int m_command_cycles;

    // Same variable, not decremented 
    int m_command_cycles_persistent;
    
    // Map of string to string that holds the Master's paramter values
    MapStringType m_ParamMap;

};

#endif // _ocp20MasterSysC_h
