# use gmake

TARGET_ARCH = sparcOS5
CC = CC
opt: OPT = -O
debug: OPT = -g
FLAGS =
PROGRAM = run21

INC = -I../ -I. -I$(SYSTEMC)/include

.cpp.o:
	$(CC) $(OPT) $(FLAGS) $(INC) -c $<

LDPATH += -L $(SYSTEMC)/lib-$(TARGET_ARCH)
LDLIBS += -lsystemc -lm


SOURCES = \
	ocp_tl2_master.o \
	ocp_tl2_slave.o \
	ocp_tl2_bus.o \
	ocp_tl2_top1.o


OBJECTS = $(SOURCES:%.cpp=%.o)

# Standard targets.

debug | opt: $(SOURCES) $(OBJECTS) Make_ocp_tl2_top1.cc
	$(CC) $(OPT) -o $(PROGRAM) $(OBJECTS) $(LDPATH) $(LDLIBS)

clean::
	- rm *.o
	- rm -rf SunWS_cache
