// 
//  (c) Copyright OCP-IP 2006
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc
//          $Id:
//
//  Description : declaration of simple OCP TL3 bus
//
// ============================================================================

#ifndef _OCP_TL3_BUS_H
#define _OCP_TL3_BUS_H

#include "ocpip.h"

class ocp_tl3_bus
  : public sc_core::sc_module
{
public:

  ocpip::ocp_slave_socket_tl3<32, 0>  ocp_s;
  ocpip::ocp_master_socket_tl3<32, 0> ocp_m;
  //OCP_TL3_SlaveMultiPort<requestType,responseType>  ocp_s;
  //OCP_TL3_MasterMultiPort<requestType,responseType> ocp_m;
        
  // this module has SC processes
  SC_HAS_PROCESS(ocp_tl3_bus);
  
  // --------------------------------------------------------------------
  void request_method();
  void response_method();
   
  // -----------------------------------------------------------------------
  // constuctor
  // ---------------------------------------------------------------------
  ocp_tl3_bus(sc_core::sc_module_name mod);
    
  void start_of_simulation();
private:
  // -----------------------------------------------------------------------
  // Internal class members 
  // -----------------------------------------------------------------------
  void do_req();
  void do_req_acc();
  void do_resp();
  void do_resp_acc();
  tlm::tlm_sync_enum nb_transport_fw(unsigned int index, tlm::tlm_generic_payload& gp, tlm::tlm_phase& ph, sc_core::sc_time & t);
  tlm::tlm_sync_enum nb_transport_bw(unsigned int index, tlm::tlm_generic_payload& gp, tlm::tlm_phase& ph, sc_core::sc_time & t);

  // OCP Request/Response structures
  std::vector<std::pair<tlm::tlm_generic_payload*, sc_core::sc_time> > m_pending_reqs;
  tlm::tlm_generic_payload* m_running_resp, *m_running_req;
  std::deque<unsigned int> m_resp_waiting_masters;
  
  struct rsp_struct {bool dont_resp_acc; tlm::tlm_generic_payload* txn;};
  std::deque<rsp_struct> m_pending_resp;
  
  unsigned int	m_index;
  unsigned int	m_previous_resp_index, m_state, m_resp_state;
  int		m_active_master_id;
  sc_core::sc_event m_resp_event, m_req_event, m_req_end_event, m_resp_end_event, m_resp_bus_free;
  sc_core::sc_time  m_clk_period, m_time, m_req_end_time, m_resp_end_time;
  tlm::tlm_phase m_ph;
  bool m_dont_resp_acc;
};

#endif
