// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: master.cc,v 1.2 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Master::Master (sc_core::sc_module_name name_): 
  sc_core::sc_module (name_), ipP("ipPort", m_socket_type::mm_txn_with_be_and_data()), ongoing_req(false), resp(NULL) {

  // initialize common members
  cnt = 0;
  dataCnt = 0;
  addrCnt = 0;
  SC_METHOD(proc);
  sensitive<<clk.pos(); 
  dont_initialize();
  ipP.register_nb_transport_bw(this, &Master::nb_transport);
  ipP.activate_synchronization_protection();
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Master::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
void Master::proc() {

  // check if channel is free
  if (!ongoing_req) {
    // Set OCP command type
    req=ipP.get_transaction();
    ipP.reserve_data_size(*req, sizeof(Td));
    ipP.reserve_be_size(*req, sizeof(Td));
    req->set_byte_enable_length(sizeof(Td));
    req->set_address(addrCnt);
    req->set_streaming_width(sizeof(Td));
    req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);
    
    if ((cnt%5)==0){
      req->set_command(tlm::TLM_WRITE_COMMAND);
      ipP.validate_extension<ocpip::posted>(*req);
    }
    else
      req->set_command(tlm::TLM_READ_COMMAND);

    // force_aligned is supposed to be true
    unsigned int ByteEn;
    if ((cnt%3)==0){
      ByteEn = 0x3;
    }
    else if ((cnt%5)==0)
      ByteEn = 0xC;
    else
      ByteEn = 0xF;

    if (tlm::get_host_endianness()==tlm::TLM_BIG_ENDIAN){
      unsigned int mask=0x1<<(sizeof(Td)-1);
      for (unsigned int i=0; i<sizeof(Td); i++){
        if (ByteEn & mask) req->get_byte_enable_ptr()[i]=0xFF;
        else req->get_byte_enable_ptr()[i]=0x0;
        mask>>=1;
      }
    }
    else{
      unsigned int mask=0x1;
      for (unsigned int i=0; i<sizeof(Td); i++){
        if (ByteEn & mask) req->get_byte_enable_ptr()[i]=0xFF;
        else req->get_byte_enable_ptr()[i]=0x0;
        mask<<=1;
      }
    }
    
    if (req->get_command() == tlm::TLM_WRITE_COMMAND) *((Td*)(req->get_data_ptr()))=dataCnt++;
    
    
    // Send request
    time=sc_core::SC_ZERO_TIME;
    phase=tlm::BEGIN_REQ;
    tlm::tlm_sync_enum retVal = ipP->nb_transport_fw(*req, phase, time);
    switch(retVal){
      case tlm::TLM_ACCEPTED: ongoing_req=true; break;
      case tlm::TLM_UPDATED: 
        switch (phase){
          case tlm::END_REQ:
            break;
          default:
            std::cerr<<"Error in "<<name()<<" : got unexpected phase update to "<<phase<<" in response to BEGIN_REQ."<<std::endl;
            exit(1);                
        }
        break;
      case tlm::TLM_COMPLETED:;
    }

      
#ifdef DEBUG_G1
    std::cout << "Master sent request " << req->get_command()
              << " time " << sc_core::sc_time_stamp().to_seconds();
    if (req->get_command() == tlm::TLM_WRITE_COMMAND) {
      std::cout << " data " << (*((Td*)(req->get_data_ptr())));
    }
    std::cout << std::endl;
#endif

    if (addrCnt<60)
      addrCnt += 4;
    else
      addrCnt = 0;
    cnt++;
  }


  if (resp) {
    time=sc_core::SC_ZERO_TIME;
    phase=tlm::END_RESP;
    ipP->nb_transport_fw(*resp, phase, time);  
    if (resp->get_response_status() == tlm::TLM_OK_RESPONSE) {
#ifdef DEBUG_G1
      std::cout << "Master got valid response "
	   << "  time  = " << sc_core::sc_time_stamp().to_seconds()
	   << "  data  = " << (*((Td*)(resp->get_data_ptr()))) << std::endl;
#endif
    }
    ipP.release_transaction(resp); //we are done with this txn now
    resp=NULL;
  }
} // end of method

tlm::tlm_sync_enum Master::nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim) {
  switch(ph){
    case tlm::END_REQ:
      ongoing_req=false;
      break;
    case tlm::BEGIN_RESP: resp=&txn;
      break;
    default:
      std::cerr<<"Error in "<<name()<<" : got unexpected phase "<<ph<<" in nb_transport_bw"<<std::endl;
      exit(1);
  }
  return tlm::TLM_ACCEPTED;
}

