// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: slave.cc,v 1.2 2004/09/05 17:57:56 halexan Exp $
//
//  Description : OCP API - Layer-1 Simple Example slave
//    Features:
//    - Synchronous
//    - Non-blocking methods are used
//    - Not pipelined
// ============================================================================

#include "slave.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
template<class TdataCl> Slave<TdataCl>::Slave (sc_module_name name_)
  : sc_module (name_), tpP("tpPort") {

  // initialize common members
  is_req = false;
  tmp = false;
  resp.SData = 0;
  last_request = OCP_MCMD_IDLE;

  SC_METHOD(proc);
  sensitive_pos(clk);
  dont_initialize(); // make sure we execute only at clock edge
}


// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<class TdataCl> Slave<TdataCl>::~Slave(){}


// ----------------------------------------------------------------------------
//  Method : Slave::proc()
//
//  Synchronous slave process
//
// ----------------------------------------------------------------------------

template<class TdataCl> void Slave<TdataCl>::proc(){

  // If a previous read has been served, we check for new requests
  if (last_request != OCP_MCMD_RD) {
    is_req = tpP->getOCPRequest(req, true); // accept automatically
    if (is_req)
      last_request = req.MCmd;
  }

  // If request was write
  if (last_request == OCP_MCMD_WR) {
#ifdef DEBUG_G1
    cout << "Slave got write request "
	 << "  time  = " << sc_time_stamp().to_seconds()
	 << "  data  = " << req.MData << endl;
#endif
    last_request = OCP_MCMD_IDLE;
  }
  else if (last_request == OCP_MCMD_RD) {
	
#ifdef DEBUG_G1
    cout << "Slave got read request "
	 << "  time  = " << sc_time_stamp().to_seconds()
	 << "  address  = " << req.MAddr << endl;
#endif

    tmp = tpP->getMBusy();
    if (!tmp) {
      // Set OCP response
      resp.SResp = OCP_SRESP_DVA;
      // Send response
      tpP->startOCPResponse(resp);
#ifdef DEBUG_G1
      cout << "Slave sent response " << resp.SResp
	   << " time " << sc_time_stamp().to_seconds()
	   << " data " << resp.SData << endl;
#endif
      
      resp.SData++;
      last_request = OCP_MCMD_IDLE;
    }
  } // end if (last_request)
} // end of method


// ----------------------------------------------------------------------------
//
//  Instantiation of the Slave
//
// ----------------------------------------------------------------------------
template class Slave< OCP_TL1_SIGNAL_CL >; // see ocp_tl1_globals.h

