# use gmake

TARGET_ARCH = sparcOS5
CC = CC
opt: OPT = -O
debug: OPT = -g
FLAGS =
PROGRAM = run30

INC = -I../ -I. -I$(SYSTEMC)/include

.cpp.o:
	$(CC) $(OPT) $(FLAGS) $(INC) -c $<


LDPATH += -L $(SYSTEMC)/lib-$(TARGET_ARCH)
LDLIBS += -lsystemc -lm

SOURCES = \
	tl3_master.o \
	tl3_slave.o \
	tl3_top0.o
        


OBJECTS = $(SOURCES:%.cpp=%.o)

# Standard targets.

debug | opt: $(SOURCES) $(OBJECTS) Make_tl3_top0.cc
	$(CC) $(OPT) -o $(PROGRAM) $(OBJECTS) $(LDPATH) $(LDLIBS)

clean::
	- rm *.o
	- rm -rf SunWS_cache
