// Copyright (c) 2004 Sonics, Inc.
//
// Confidential and Proprietary Information of Sonics, Inc.
// Use, disclosure, or reproduction is prohibited without
// written permission from Sonics, Inc.
//
// $Id: LineBuffer.cc,v 1.1 2007/01/25 22:09:07 halexan Exp $

#include "LineBuffer.h"
#include <stdexcept>
#include <iostream>

using namespace std;
using namespace Sonics;
LineBuffer::LineBuffer( const string& fileName, unsigned int bufferSize ) :
    m_fileName( fileName ),
    m_lineNum( 0 ),
    m_numSlurpLines( bufferSize ),
    m_lastStop( ios::beg )
{}

string
LineBuffer::getCurrentLine() const
{
    if ( m_stringBuffer.empty() )
        throw out_of_range( "Line buffer is empty" );
    return m_stringBuffer.front();
}

string
LineBuffer::getNextLine( int& len )
{
    if ( m_stringBuffer.empty() && !slurp() ) {
        len = -1;
        return "";
    }
    string line = m_stringBuffer.front();
    m_stringBuffer.pop_front();
    len = line.size();
    ++m_lineNum;
    return line;
}

bool
LineBuffer::slurp()
{
    if ( m_lastStop == (streampos)ios::end )
        return false;
    open( m_fileName.c_str() );
    if ( bad() ) throw runtime_error( "File does not exist" );

    seekg( m_lastStop );
    string line;
    unsigned int count;
    for ( count=0; count < m_numSlurpLines; ++count ) {
        std::getline( *this, line );
        if ( !good() ) break;
        m_stringBuffer.push_back( line );
    }

    if ( eof() || bad() ) {
        m_lastStop = ios::end;
    } else if ( good() ) {
        m_lastStop = tellg();
    }
    close();
    return ( count != 0 );
}
