// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//         $Id: master.cc,v 1.3 2006/02/03 18:04:06 tkogel Exp $
//
//  Description : OCP API - Layer-1 test Master
//    Features:
//    - Synchronous
//    - Non-blocking methods are used
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
template<unsigned int BUSWIDTH, unsigned int ADDRWIDTH> Master<BUSWIDTH, ADDRWIDTH>::Master (sc_core::sc_module_name name_): 
  sc_core::sc_module (name_), ipP("ipPort", ocpip::ocp_master_socket_tl1<sizeof(Td)*8>::mm_txn_with_data()), ongoing_req(false), rsp(NULL) {

  // initialize common members
  cnt = 0;
  dataCnt = 0;
  addrCnt = 0;
  SC_METHOD(proc);
  sensitive<<clk.pos(); 
  dont_initialize();
  ipP.register_nb_transport_bw(this, &Master::nb_transport);
  ipP.activate_synchronization_protection();
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<unsigned int BUSWIDTH, unsigned int ADDRWIDTH> Master<BUSWIDTH, ADDRWIDTH>::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
template<unsigned int BUSWIDTH, unsigned int ADDRWIDTH> void Master<BUSWIDTH, ADDRWIDTH>::proc() {

  // check if channel is free
  if (!ongoing_req) {
    // Set OCP command type
    req=ipP.get_transaction();
    ipP.reserve_data_size(*req, sizeof(Td));
    req->set_address(addrCnt);
    req->set_byte_enable_ptr(NULL);
    req->set_streaming_width(sizeof(Td));
    req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);
    
    
    if ((cnt%5)==0){
      req->set_command(tlm::TLM_WRITE_COMMAND);
      ipP.template validate_extension<ocpip::posted>(*req);
    }
    else
      req->set_command(tlm::TLM_READ_COMMAND);

    if (req->get_command() == tlm::TLM_WRITE_COMMAND) *((Td*)(req->get_data_ptr()))=dataCnt++;
    
    // Send request
    time=sc_core::SC_ZERO_TIME;
    phase=tlm::BEGIN_REQ;
    tlm::tlm_sync_enum retVal = ipP->nb_transport_fw(*req, phase, time);
    switch(retVal){
      case tlm::TLM_ACCEPTED: ongoing_req=true; break;
      case tlm::TLM_UPDATED: 
        switch (phase){
          case tlm::END_REQ:
            if (req->get_command()==tlm::TLM_WRITE_COMMAND){
              ipP.release_transaction(req); //we are done now because writes do not have resps in this example
            }
            break;
          default:
            std::cerr<<"Error in "<<name()<<" : got unexpected phase update to "<<phase<<" in response to BEGIN_REQ."<<std::endl;
            exit(1);                
        }
        break;
      case tlm::TLM_COMPLETED:;
    }

#ifdef DEBUG_G1
    std::cout << "Master sent request " << req->get_command()
              << " time " << sc_core::sc_time_stamp().to_seconds();
    if (req->get_command() == tlm::TLM_WRITE_COMMAND) {
      std::cout << " data " << (*((Td*)(req->get_data_ptr())));
    }
    std::cout << std::endl;
#endif
      
    addrCnt += 4;
    cnt++;
  }

  if (rsp) {
    time=sc_core::SC_ZERO_TIME;
    phase=tlm::END_RESP;
    ipP->nb_transport_fw(*rsp, phase, time);  
    if (rsp->get_response_status() == tlm::TLM_OK_RESPONSE) {
#ifdef DEBUG_G1
      std::cout << "Master got valid response "
	   << "  time  = " << sc_core::sc_time_stamp().to_seconds()
	   << "  data  = " << (*((Td*)(rsp->get_data_ptr()))) << std::endl;
#endif
    }
    ipP.release_transaction(rsp); //we are done with this txn now
    rsp=NULL;
  }
} // end of method

template<unsigned int BUSWIDTH, unsigned int ADDRWIDTH>
tlm::tlm_sync_enum Master<BUSWIDTH, ADDRWIDTH>::nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim) {
  switch(ph){
    case tlm::END_REQ:
      ongoing_req=false;
      if (req->get_command()==tlm::TLM_WRITE_COMMAND){
        ipP.release_transaction(req); //we are done now because writes do not have resps in this example
      }      
      break;
    case tlm::BEGIN_RESP: rsp=&txn;
      break;
    default:
      std::cerr<<"Error in "<<name()<<" : got unexpected phase "<<ph<<" in nb_transport_bw"<<std::endl;
      exit(1);
  }
  return tlm::TLM_ACCEPTED;
}



// ----------------------------------------------------------------------------
//
//  Instantiation of the Master
//
// ----------------------------------------------------------------------------
template class Master< 32,32 >;

