// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Stephane Guntz, PROSILOG, guntz@prosilog.com
//				  Yann Bajot, PROSILOG, bajot@prosilog.com                
//         Date : 01/05/2004
//
//  Description : 
//  testbench for tl1-tl2 master adapter example
//
// The master sends a READ precise burst, with a total length of 15 elements, at each rising edge of the clock
// The start address is 0, and the address increment is 4.
// The sequence is decomposed as follows:
// At the 4th element (address=12): the MReqInfo field changes and is 1 now..
// 
// For the remaining READ requests: the address increment is still 4, MBurstLength=15, MReqInfo=1
// 
// The master adapter separates that 15 TL1-element burst into 4 TL2 chunks:
// The first chunk has a length of 3 (start address=0, end address=8, read data are 0,1,2)
// The second chunk has a length of 5, which is the maximum chunk size: it begins when the MReqInfo has changed (start address=12, end address= 28, read data=3,4,5,6,7)
// The third chunk has a length of 5 (start address=32, end address= 48, read data=8,9,10,11,12)
// The fourth and last chunk has a length of 2 (start address=52, end address= 56, read data=13,14).
//
// On the response side, for each response, the master releases the response channel after a delay of 2 clock cycles
//
// ============================================================================


#include "systemc.h"
#include "ocp_tl1_master.h"
#include "ocp_tl2_slave.h"
#include "ocp_tl1_tl2_master_adapter.h"
#include "ocp_tl1_channel.h"
#include "ocp_tl2_channel.h"

#define DEBUG_G1

using namespace std;

void readMapFromFile(const string &myFileName, MapStringType &myParamMap) 
{
    // read pairs of data from the passed file
    string leftside;
    string rightside;
    
    // (1) open the file
    ifstream inputfile(myFileName.c_str());
    assert( inputfile );

    // set the formatting
    inputfile.setf(std::ios::skipws);

    // Now read through all the pairs of values and add them to the passed map
    while ( inputfile ) {
        inputfile >> leftside;
        inputfile >> rightside;
        myParamMap.insert(std::make_pair(leftside,rightside));
    }

    // All done, close up
    inputfile.close();
}




int sc_main(int argc, char* argv[])
{
  
  sc_clock clk("clock", 1, SC_NS, 0.5, 0, SC_NS, true);

  //TL1 and TL2 channels instantiation 
  OCP_TL1_Channel<OCP_TL1_DataCl<int , int> > *channel0=new OCP_TL1_Channel<OCP_TL1_DataCl<int , int> >("channel0");
  OCP_TL2_Channel< int , int> *channel1=new OCP_TL2_Channel< int , int >("channel1");


  // Set the OCP parameters for this channel
  MapStringType  ocpParamMap;
  readMapFromFile("ocpParams_master_adapter_tl1_tl2", ocpParamMap);
  channel1->setConfiguration(ocpParamMap);
  channel0->setConfiguration(ocpParamMap);


  //TL1 master instantiation 
   OCP_TL1_Master<OCP_TL1_DataCl<int , int> > *master1=new OCP_TL1_Master<OCP_TL1_DataCl<int , int> >("ms1", 1, 1, 20);
  //TL1 slave instantiation: pipelined, no response to a write request
  //no accept and response delays
  OCP_TL2_Slave *slave1=new OCP_TL2_Slave("sl1", 1, 0x0, 0x3FF, true, false, 0, 0, 0, 0);

  //adapter instantiation
  //maximum chunk length=5, adapter depth= 6, timeout=(2, SC_NS)
  sc_time timeout=sc_time(2, SC_NS);
  OCP_TL1_TL2_Master_Adapter<OCP_TL1_DataCl<int , int> > *master_adapter=new OCP_TL1_TL2_Master_Adapter<OCP_TL1_DataCl<int , int> >("master_adapter1", 5, 6, timeout);


  //binding
  master1->MasterP(*channel0);
  master1->clk(clk);

  master_adapter->SlaveP(*channel0);
  master_adapter->MasterP(*channel1);
  master_adapter->clk(clk);

  slave1->SlaveP(*channel1);

  sc_start(50, SC_NS);

  return 0;
}



