// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level Layer-1
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//                Yann Bajot, Prosilog, bajot@prosilog.com
//
//  Description : Transaction Level - Layer-1 example Master
//  $Id: ocp_tl1_master_async.h,v 1.1.1.1 2004/09/24 09:26:15 sguntz Exp $
//
// ============================================================================

#ifndef _OCP_TL1_MASTER_ASYNC_H
#define _OCP_TL1_MASTER_ASYNC_H

#include "systemc.h"

#include "ocp_globals.h"
#include "ocp_tl1_master_if.h"

// Timings are defined in the testbench (top*.cpp)
extern const sc_time_unit TL_TIME_UNIT; 
extern const double TL_CLK_PERIOD ;     // clock period


template <class TdataCl> class OCP_TL1_Master_Async
  : public sc_module
  , public MdirectIF<TdataCl>
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  sc_port<OCP_TL1_MasterIF<TdataCl>, 1> MasterP;
  sc_in_clk  clk;

  SC_HAS_PROCESS(OCP_TL1_Master_Async);

  // constructor
  OCP_TL1_Master_Async(sc_module_name name_
             , int ID
             , int Priority
             , double RequestDelay
             , double ResponseDelay
            );

  // destructor
  ~OCP_TL1_Master_Async();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);
  void MasterRequest();
  void MasterResponse();


private :

  void end_of_elaboration();

    // Structures used to handle TL1 Requests/Responses
  OCPResponseGrp<Td>   TL1_response;
  OCPRequestGrp<Td,Ta>   TL1_request;

  // parameters
  int m_ID;
  int m_Priority;
  double m_RequestDelay;
  double m_ResponseDelay;
};


#endif // _OCP_TL1_MASTER_ASYNC_H
