// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: master.cc,v 1.4 2006/02/03 18:05:30 tkogel Exp $
//
//  Description : OCP API - Layer-2 test Master
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
template<class Td, class Ta> Master<Td, Ta>::Master (sc_module_name name_): 
  sc_module (name_), ipP("ipPort") {

  // initialize common members
  tmp = 0;
  cnt = 0;
  req.MAddr = 0;

  SC_THREAD(proc_req);
  SC_THREAD(proc_resp);
  
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<class Td, class Ta> Master<Td, Ta>::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc_req()
//
//  Master request process
//
// ----------------------------------------------------------------------------
template<class Td, class Ta> void Master<Td, Ta>::proc_req() {
  Td MData = 0;
  req.MDataPtr = &MData;
  while(true) {
    // Set OCP command type
    if ((cnt%5)==0)
      req.MCmd = OCP_MCMD_WR;
    else
      req.MCmd = OCP_MCMD_RD;
    
#ifdef DEBUG_G1
    cout << "Master sent request " << req.MCmd
	 << " time " << sc_time_stamp().to_seconds();
    if (req.MCmd == OCP_MCMD_WR) {
      cout << " data " << req.MDataPtr[0];
    }
    cout << endl;
#endif
    // Send request
    tmp = ipP->startOCPRequestBlocking(req);
    if (tmp) {
      if (req.MCmd == OCP_MCMD_WR) {
	MData++;
      }
      req.MAddr += 4;
      cnt++;
    }
  }
} // end of method
  
// ----------------------------------------------------------------------------
//  Method : Master::proc_resp()
//
//  Master response process
//
// ----------------------------------------------------------------------------
template<class Td, class Ta> void Master<Td, Ta>::proc_resp() {
  // Check for response
  unsigned int size;
  bool release = false;
  bool last = true;
  sc_time delay = sc_time(2, SC_NS);

  while (true) {    
    tmp = ipP->getOCPResponseBlocking(resp, release, size, last);
    if (tmp) {
      if (resp.SResp == OCP_SRESP_DVA) {
#ifdef DEBUG_G1
	cout << "Master got valid response "
	     << "  time  = " << sc_time_stamp().to_seconds()
	     << "  data  = " << resp.SDataPtr[0] << endl;
#endif
	ipP->putMRespAccept(delay);
      }
    }
  }
  
} // end of method


template class Master<Td, Ta>;


