// A module of digital 4 to 1 mux

`timescale 1ns/1fs
module mux4to1(
	output logic out,
	input logic [3:0] in,
	input logic [1:0] sel,      //Select bits - 00 = in[0], 01 = in[1], 10 = in[2], 11 = in[3]
	input logic en
	);
    
  logic outval;        //Logic variable for mux output voltage
  bit clk_in_comfirm;
	always_comb
		case(sel)
		    2'b00:  outval = (en == 1) ? (in[0]) : 0; // div4
		    2'b01:  outval = (en == 1) ? (in[1]) : 0; // div2
		    2'b10:  outval = (en == 1) ? (in[2]) : 0; // fx1
		    2'b11:  outval = (en == 1) ? (in[3]) : 0; // fx2
		endcase
	
	assign out = (clk_in_comfirm) ? outval : 0;


  // fork to detect if clk_in is oscillating
  always begin
    fork 
      begin
        @(posedge outval);
        clk_in_comfirm = 1;
        disable TIMEOUT;
      end
      TIMEOUT:begin
        #(2.001ns) clk_in_comfirm = 0;
      end
    join_any
  end 

endmodule
